<?php
namespace MetaFox\Platform\Traits\Helpers;

use Illuminate\Support\Arr;
use MetaFox\Core\Support\Output;
use MetaFox\Hashtag\Traits\HasHashtagTextTrait;
use MetaFox\Platform\Contracts\Content;
use MetaFox\Platform\Contracts\HasFeedContent;
use MetaFox\Platform\Contracts\HasHashTag;
use MetaFox\Platform\Contracts\HasLocationCheckin;

/**
 * @property
 */
trait ShareFeedInfoTrait
{
    use IsFriendTrait;
    use HasHashtagTextTrait;

    public function toLocation(HasLocationCheckin $item): ?array
    {
        [$address, $lat, $lng] = $item->toLocation();

        if ($address && $lat && $lng) {
            return [
                'address' => $address,
                'lat'     => (float) $lat,
                'lng'     => (float) $lng,
            ];
        }

        return null;
    }

    public function toFeedContent(HasFeedContent $item): ?string
    {
        if (!$item instanceof Content) {
            return null;
        }

        $feed = $item->activity_feed;

        if (!$feed instanceof Content) {
            return null;
        }

        return $this->getFeedTransformContent($feed);
    }

    protected function parseFeedHashtags(HasHashTag $feed, string $content): string
    {
        $resourceHashtags = $this->buildResourceTags($feed);

        return preg_replace_callback(sprintf('/%s/', Output::HASHTAG_REGEX), function ($matches) use ($resourceHashtags) {
            $search = array_shift($matches);

            $hashtag = $this->convertToHashtag(ltrim($search, '#'));

            $tagUrl = Arr::get($resourceHashtags, $hashtag);

            if (!is_string($tagUrl)) {
                return $search;
            }

            return parse_output()->buildHashtagLink($search, $tagUrl);
        }, $content);
    }

    protected function getFeedTransformContent(Content $feed): ?string
    {
        $content = $feed->content;

        if (!is_string($content)) {
            return null;
        }

        $content = parse_output()->parse($content);

        if ($feed instanceof HasHashTag) {
            $content = $this->parseFeedHashtags($feed, $content);
        }

        app('events')->dispatch('core.parse_content', [$feed, &$content]);

        return $content;
    }
}
