<?php
/**
 * @author  developer@phpfox.com
 * @license phpfox.com
 */

namespace MetaFox\Platform\Support;

use Illuminate\Support\Arr;
use Illuminate\Support\Collection;
use MetaFox\Platform\Contracts\User;

/**
 * Class ContentParser.
 * @SuppressWarnings(PHPMD.CamelCasePropertyName)
 */
class ContentParser
{
    public const LINK_CONTENT = "<a href='%s' target='%s' id='%d' type='%s'>%s</a>";
    public const BOLD_CONTENT = '<b>%s</b>';
    protected string $pattern;
    protected string $content;
    protected string $target;
    protected bool $parseUrl;
    protected bool $parseUserFullLink;

    /**
     * @return bool
     */
    public function isParseUrl(): bool
    {
        return $this->parseUrl;
    }

    /**
     * @param bool $parseUrl
     */
    public function setParseUrl(bool $parseUrl = true): void
    {
        $this->parseUrl = $parseUrl;
    }

    /**
     * @return bool
     */
    public function isParseUserFullLink(): bool
    {
        return $this->parseUserFullLink;
    }

    /**
     * @param bool $parseUserFullLink
     */
    public function setParseUserFullLink(bool $parseUserFullLink = false): void
    {
        $this->parseUserFullLink = $parseUserFullLink;
    }

    protected Collection $userCollection;

    /**
     * @return Collection
     */
    public function getUserCollection(): Collection
    {
        return $this->userCollection;
    }

    /**
     * @param Collection $userCollection
     */
    public function setUserCollection(Collection $userCollection): void
    {
        $this->userCollection = $userCollection;
    }

    /**
     * @return string
     */
    public function getContent(): string
    {
        return $this->content;
    }

    /**
     * @param string $content
     */
    public function setContent(string $content): void
    {
        $this->content = $content;
    }

    /**
     * @return string
     */
    public function getTarget(): string
    {
        return $this->target;
    }

    /**
     * @param string $target
     */
    public function setTarget(string $target = '_self'): void
    {
        $this->target = $target;
    }

    /**
     * @return string
     */
    public function getPattern(): string
    {
        return $this->pattern;
    }

    /**
     * @param string $pattern
     */
    public function setPattern(string $pattern): void
    {
        $this->pattern = $pattern;
    }

    public function attributeParser(array $attribute): void
    {
        $this->setTarget(Arr::get($attribute, 'target', '_self'));
        $this->setParseUrl(Arr::get($attribute, 'parse_url', true));
        $this->setParseUserFullLink(Arr::get($attribute, 'parse_full_link', false));
    }

    public function parse(): ?string
    {
        return preg_replace_callback($this->getPattern(), function ($params) {
            [, $userId, $oldName] = $params;

            if (!$this->isParseUrl()) {
                return $oldName;
            }

            $model = $this->getUserCollection()->get($userId);

            if (!$model instanceof User) {
                return sprintf(self::BOLD_CONTENT, $oldName);
            }

            $href = $this->isParseUserFullLink() ? $model->toUrl() : $model->toLink();

            if ($href && $model->isTaggingAllowed()) {
                return sprintf(self::LINK_CONTENT, $href, $this->getTarget(), $model->entityId(), $model->entityType(), $model->toTitle());
            }

            return sprintf(self::BOLD_CONTENT, $model->toTitle());
        }, $this->getContent());
    }
}
