<?php

namespace MetaFox\Platform\Http\Resources\Abstract;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\ResourceCollection as LaravelResourceCollection;

class ResourceCollection extends LaravelResourceCollection
{
    /**
     * Transform the resource into a JSON array.
     *
     * @param  \Illuminate\Http\Request                                        $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray(Request $request)
    {
        return $this->collection->map->toArray($request)
            ->filter(function ($item) {
                return !empty($item);
            })->all();
    }
}
