<?php

namespace MetaFox\User\Rules;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\Validator;
use MetaFox\Sms\Rules\PhoneNumberRule;
use MetaFox\User\Repositories\Contracts\UserRepositoryInterface;

/**
 * Class ExistsInEmailOrPhoneNumberRule.
 *
 * @SuppressWarnings(PHPMD.UnusedFormalParameter)
 */
class ExistsInEmailOrPhoneNumberRule implements Rule
{
    public function passes($attribute, $value)
    {
        $user = resolve(UserRepositoryInterface::class)->findUserByEmailOrPhoneNumber($value);

        if (null == $user) {
            return false;
        }

        $isEmail = Validator::make(
            [$attribute => $value],
            [$attribute => 'email']
        )->passes();

        if ($isEmail && !$user->hasVerifiedEmail()) {
            return false;
        }

        $isPhoneNumber = Validator::make(
            [$attribute => $value],
            [$attribute => new PhoneNumberRule()]
        )->passes();

        if ($isPhoneNumber && !$user->hasVerifiedPhoneNumber()) {
            return false;
        }

        return true;
    }

    public function message()
    {
        return __p('user::validation.cannot_find_this_user');
    }
}
