<?php

namespace MetaFox\User\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use MetaFox\User\Models\User;
use MetaFox\Platform\Contracts\Content;
use MetaFox\User\Repositories\UserProfileRepositoryInterface;

class CleanUserCoverAfterDeletePhotoJob implements ShouldQueue, ShouldBeUnique
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    private Content $photo;

    public function uniqueId(): string
    {
        return __CLASS__;
    }

    public function __construct(Content $photo)
    {
        $this->photo = $photo;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle(): void
    {
        $query = $this->profileRepository()
            ->getModel()
            ->newQuery()
            ->where('cover_id', $this->photo->entityId())
            ->where('cover_type', $this->photo->entityType());

        foreach ($query->cursor() as $user) {
            if (!$user instanceof User) {
                continue;
            }

            $user->updateQuietly([
                'cover_id'             => 0,
                'cover_file_id'        => 0,
                'cover_photo_position' => 0,
            ]);
        }
    }

    protected function profileRepository(): UserProfileRepositoryInterface
    {
        return resolve(UserProfileRepositoryInterface::class);
    }
}
