<?php

namespace MetaFox\User\Http\Resources\v1\UserInactive\Admin;

/*
 | --------------------------------------------------------------------------
 | DataGrid Configuration
 | --------------------------------------------------------------------------
 | stub: src/Http/Resources/v1/Admin/DataGrid.stub
 */

use MetaFox\Form\Constants as MetaFoxForm;
use MetaFox\Platform\Resource\Actions;
use MetaFox\Platform\Resource\BatchActionMenu;
use MetaFox\Platform\Resource\GridConfig as Grid;
use MetaFox\Platform\Resource\ItemActionMenu;

/**
 * Class DataGrid.
 * @codeCoverageIgnore
 * @ignore
 */
class DataGrid extends Grid
{
    protected string $appName      = 'user';
    protected string $resourceName = 'inactive';

    protected function initialize(): void
    {
        $this->title(__p('user::phrase.manage_genders'));
        $this->setSearchForm(new SearchUserInactiveForm());

        $this->setDataSource(apiUrl('admin.user.inactive.index'), [
            'q'                => ':q',
            'day'              => ':day',
            'email'            => ':email',
            'phone_number'     => ':phone_number',
            'group'            => ':group',
            'status'           => ':status',
            'gender'           => ':gender',
            'postal_code'      => ':postal_code',
            'country_state_id' => ':country_state_id',
            'country'          => ':country',
            'age_from'         => ':age_from',
            'age_to'           => ':age_to',
            'sort'             => ':sort',
            'ip_address'       => ':ip_address',
        ]);

        $this->enableCheckboxSelection();

        $this->addColumn('user')
            ->header(__p('core::web.photo'))
            ->renderAs('AvatarCell')
            ->width(120);

        $this->addColumn('full_name')
            ->header(__p('user::phrase.display_name'))
            ->linkTo('user_link')
            ->target('_blank')
            ->asFeaturedUser()
            ->width(200);

        $this->addColumn('email')
            ->header(__p('core::phrase.email_address'))
            ->asEmail('email')
            ->flex();

        $this->addColumn('role_name')
            ->header(__p('core::web.groups'))
            ->width(200)
            ->flex();

        $this->addColumn('last_activity')
            ->header(__p('user::phrase.last_activity'))
            ->sortable()
            ->asDateTime()
            ->flex();

        $this->addColumn('last_login')
            ->header(__p('user::phrase.last_login'))
            ->sortable()
            ->asDateTime()
            ->flex();

        $this->addColumn('ip_address')
            ->header(__p('user::phrase.ip_address'))
            ->sortable()
            ->flex();

        /*
         * Add default actions
         */
        $this->withActions(function (Actions $actions) {
            $actions->add('batchProcessMailing')
                ->asPatch()
                ->asFormDialog(false)
                ->apiUrl('admincp/user/batch-process-mailing?id=[:id]');

            $actions->add('processMailing')
                ->apiUrl('admincp/user/process-mailing/:id')
                ->asPatch();
        });

        /*
         * with batch menu actions
         */
        $this->withBatchMenu(function (BatchActionMenu $menu) {
            $menu->asButton();

            $menu->addItem('batchProcessMailing')
                ->action('batchProcessMailing')
                ->label(__p('user::phrase.process_mailing_job_to_selected'))
                ->reload()
                ->asBatchEdit();
        });

        /*
         * with item action menus
         */
        $this->withItemMenu(function (ItemActionMenu $menu) {
            $menu->addItem('processMailing')
                ->action('processMailing')
                ->label(__p('user::phrase.process_mailing_job'))
                ->value(MetaFoxForm::ACTION_ADMINCP_BATCH_ITEM)
                ->reload();
        });
    }
}
