<?php

namespace MetaFox\User\Http\Resources\v1\User\Admin;

use MetaFox\Form\AbstractForm;
use MetaFox\Profile\Repositories\ProfileRepositoryInterface;
use MetaFox\User\Models\User as Model;
use MetaFox\User\Repositories\Contracts\UserRepositoryInterface;

/**
 * Class AccountCustomFieldSettingForm.
 * @property Model $resource
 * @driverType form
 * @driverName user.update.custom_field
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
 */
class AccountCustomFieldSettingForm extends AbstractForm
{
    public function boot(int $id, UserRepositoryInterface $repository): void
    {
        $this->resource = $repository->find($id);
    }

    protected function prepare(): void
    {
        $values = resolve(ProfileRepositoryInterface::class)->denormalize($this->resource);

        $this->title(__p('core::web.custom_fields'))
            ->action('admincp/user/custom-field/' . $this->resource->id)
            ->asPatch()
            ->setValue($values);
    }

    public function initialize(): void
    {
        resolve(ProfileRepositoryInterface::class)
            ->loadEditFields($this, $this->resource);
        $this->addDefaultFooter(true);
    }
}
