<?php

namespace MetaFox\User\Http\Requests\v1\User;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Validator;
use MetaFox\Platform\Rules\CaseInsensitiveUnique;
use MetaFox\Platform\Rules\RegexUsernameRule;
use MetaFox\Platform\Rules\UniqueSlug;
use MetaFox\Sms\Rules\PhoneNumberRule;

/**
 * Class ExistRequest.
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 * @SuppressWarnings(PHPMD.CyclomaticComplexity)
 * @SuppressWarnings(PHPMD.NPathComplexity)
 * @SuppressWarnings(PHPMD.UnusedFormalParameter)
 */
class ExistRequest extends FormRequest
{
    protected function prepareForValidation()
    {
        $email = $this->input('email');

        // override the phone_number if the email matches the phone number format
        $emailIsPhoneNumber = Validator::make([
            'phone_number' => $email,
        ], [
            'phone_number' => new PhoneNumberRule(),
        ])->passes();

        if ($emailIsPhoneNumber) {
            $this->merge([
                'phone_number' => $email,
                'email'        => '',
            ]);
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules(): array
    {
        return [
            'email'        => [
                'required_without_all:user_name,phone_number',
                'string',
                'email',
                new CaseInsensitiveUnique('users', 'email'),
            ],
            'phone_number' => [
                'required_without_all:user_name,email',
                'string',
                new PhoneNumberRule(),
                new CaseInsensitiveUnique('users', 'phone_number'),
            ],
            'user_name'    => [
                'required_without_all:email,phone_number',
                'string',
                new UniqueSlug('user'),
                new RegexUsernameRule(),
            ],
        ];
    }

    public function validated($key = null, $default = null)
    {
        return parent::validated();
    }
}
