<?php

namespace MetaFox\User\Http\Requests\v1\User;

use Illuminate\Auth\AuthenticationException;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Hash;
use MetaFox\User\Rules\ActiveReasonRule;

/**
 * Class DeleteRequest.
 */
class DeleteRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     * @throws AuthenticationException
     */
    public function rules(): array
    {
        $context = user();
        $rules   = [
            'reason_id' => ['sometimes', 'numeric', new ActiveReasonRule()],
            'feedback'  => ['sometimes', 'string', 'nullable'],
        ];

        if ($context->getAuthPassword()) {
            Arr::set($rules, 'password', ['required', 'string']);
        }

        return $rules;
    }

    /**
     * @throws AuthenticationException
     */
    public function validated($key = null, $default = null)
    {
        $context  = user();
        $data     = parent::validated($key, $default);
        $password = Arr::get($data, 'password');

        if ($context->hasSuperAdminRole()) {
            abort(401, __p('user::phrase.password_is_not_correct'));
        }

        if (!$password) {
            return $data;
        }

        if (!Hash::check($password, $context->getAuthPassword())) {
            abort(422, __p('user::phrase.password_is_not_correct'));
        }

        return $data;
    }
}
