<?php

namespace MetaFox\User\Http\Requests\v1\User\Admin;

use Illuminate\Auth\AuthenticationException;
use Illuminate\Support\Arr;
use MetaFox\Profile\Repositories\ProfileRepositoryInterface;
use MetaFox\User\Http\Requests\v1\User\UpdateRequest as UserUpdateRequest;
use MetaFox\User\Support\Browse\Scopes\User\CustomFieldScope;
use MetaFox\User\Support\Facades\UserEntity;

/**
 * --------------------------------------------------------------------------
 *  Http request for api version v1
 * --------------------------------------------------------------------------.
 *
 * This class is used by automatic dependency injection:
 *
 * @link \MetaFox\User\Http\Controllers\Api\v1\UserAdminController::updateCustomFields;
 * stub: /packages/requests/api_action_request.stub
 */

/**
 * Class UpdateCustomFieldsRequest.
 */
class UpdateCustomFieldsRequest extends UserUpdateRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     * @throws AuthenticationException
     */
    public function rules(): array
    {
        $userId = $this->route('id');
        $rules  = new \ArrayObject([]);

        $user = user();
        if ($userId > 0) {
            $user = UserEntity::getById($userId)->detail;
        }

        resolve(ProfileRepositoryInterface::class)->loadEditRules($rules, $user);

        return $rules->getArrayCopy();
    }

    protected function handleProfileFields(array &$data): void
    {
        $attributes = $this->getProfileFields();

        foreach ($attributes as $attribute) {
            Arr::set($data, 'profile.' . $attribute, Arr::get($data, $attribute));
        }
    }

    public function getProfileFields(): array
    {
        $fields = [];

        $allowCustomFields = CustomFieldScope::getAllowCustomFields();

        foreach ($allowCustomFields as $field) {
            $fields[] = $field->field_name;
        }

        return $fields;
    }

    public function validated($key = null, $default = null): array
    {
        $data = parent::validated($key, $default);

        $this->handleProfileFields($data);

        return $data;
    }
}
