<?php

use Illuminate\Support\Facades\Route;

Route::get('user/{id}', function ($id) {
    return seo_sharing_view('web', 'user.user.landing', 'user', $id);
});

Route::get('user', function () {
    return seo_sharing_view('web', 'user.user.landing');
});

Route::get('user/user/edit/{id}', function ($id) {
    return seo_sharing_view(
        'admin',
        'admin.user.edit_user',
        'user',
        $id,
        function ($data, $user) use ($id) {
            $label = $user?->full_name;

            if (!$label) {
                $label = $user?->user_name ?? 'User #' . $id;
            }

            $data->addBreadcrumb(__p('user::admin.manage_members'), '/user/user/browse');
            $data->addBreadcrumb($label, null);
        }
    );
});
