<?php

namespace MetaFox\Search\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use MetaFox\Core\Repositories\DriverRepositoryInterface;
use MetaFox\Platform\Contracts\HasGlobalSearch;
use MetaFox\Search\Repositories\SearchRepositoryInterface;

/**
 * stub: packages/jobs/job-queued.stub.
 */
class Reindex implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    private SearchRepositoryInterface $searchRepository;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct()
    {
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $entities = resolve(DriverRepositoryInterface::class)->loadEntities();
        foreach ($entities as $entity) {
            $object = resolve($entity);
            if (!$object instanceof HasGlobalSearch) {
                continue;
            }

            if (!$object instanceof Model) {
                continue;
            }

            $models = $object->all();
            foreach ($models as $model) {
                // TODO: optimize this
                $this->getSearchRepository()->updatedBy($model);
            }
        }
    }

    /**
     * Get the value of searchRepository.
     */
    public function getSearchRepository(): SearchRepositoryInterface
    {
        if (empty($this->searchRepository)) {
            $this->searchRepository = resolve(SearchRepositoryInterface::class);
        }

        return $this->searchRepository;
    }
}
