<?php

namespace MetaFox\Report\Listeners;

use MetaFox\Platform\Contracts\Entity;
use MetaFox\Report\Repositories\ReportItemAdminRepositoryInterface;
use MetaFox\User\Models\User;
use MetaFox\User\Repositories\Contracts\UserRepositoryInterface;

class ModelDeletedListener
{
    /**
     * @param  mixed $model
     * @return void
     */
    public function handle(mixed $model): void
    {
        if ($model instanceof Entity) {
            $this->handleDeleteReportItem($model);
        }
    }

    protected function handleDeleteReportItem(Entity $model): void
    {
        $adminUser = resolve(UserRepositoryInterface::class)->getSuperAdmin();

        if (!$adminUser instanceof User) {
            return;
        }

        resolve(ReportItemAdminRepositoryInterface::class)->deleteReportByItem(
            $adminUser,
            $model->entityType(),
            $model->entityId(),
        );
    }
}
