<?php

namespace MetaFox\Profile\Support\Facade;

use Illuminate\Support\Facades\Facade;
use MetaFox\Profile\Contracts\CustomFieldSupportInterface;

/**
 * @method static array  getEditTypeAllowOptions()
 * @method static string transformVarType(string $type)
 * @method static string transformVarTypeForSearch(string $type)
 * @method static string transformForSearch(string $varType, ?string $resolution = null)
 * @method static string transformYupType(string $varType, ?string $editType)
 * @method static bool   allowHtml(string $type)
 * @method static bool   allowLink(string $type)
 * @method static mixed  transformValueForForm(string $type, mixed &$value)
 * @method static mixed  transformValueForSection(string $type, mixed &$value, array $options)
 * @method static array  getAllowedRoleOptions()
 * @method static array  getAllowedRole()
 *
 * @see VideoSupport
 */
class CustomField extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return CustomFieldSupportInterface::class;
    }
}
