<?php

namespace MetaFox\Profile\Repositories;

use MetaFox\Platform\Contracts\User;
use MetaFox\Profile\Models\Section;
use Prettus\Repository\Eloquent\BaseRepository;

/**
 * Interface Section.
 *
 * @mixin BaseRepository
 * * @method Section getModel()
 */
interface SectionRepositoryInterface
{
    /**
     * @return array
     */
    public function getSectionForForm(): array;

    /**
     * @param  User  $user
     * @param  array $attribute
     * @return bool
     */
    public function deleteOrMoveToNewSection(User $user, array $attribute): bool;

    /**
     * @param  array<int> $orderIds
     * @return bool
     */
    public function orderSections(array $orderIds): bool;

    /**
     * @param  array   $attributes
     * @return Section
     */
    public function createSection(array $attributes): Section;
}
