<?php

namespace MetaFox\Profile\Repositories;

use Illuminate\Database\Eloquent\Collection;
use MetaFox\Form\AbstractForm;
use MetaFox\Form\Section as SectionForm;
use MetaFox\Platform\Contracts\User;
use Prettus\Repository\Eloquent\BaseRepository;

/**
 * Interface Profile.
 *
 * @mixin BaseRepository
 * stub: /packages/repositories/interface.stub
 */
interface ProfileRepositoryInterface
{
    public function loadEditFields(AbstractForm $form, $user, ?string $resolution = null): void;

    public function loadEditRules(\ArrayObject $rules, $user): void;

    public function saveValues($user, array $input): void;

    public function getFieldNames(): array;

    /**
     * @param SectionForm $section
     * @param string|null $resolution
     * @return void
     */
    public function loadFieldRegistration(SectionForm $section, ?string $resolution = null): void;

    /**
     * @param \ArrayObject $rules
     * @return void
     */
    public function loadFieldRegistrationRules(\ArrayObject $rules): void;

    /**
     * @return Collection
     */
    public function getFieldRegistration(): Collection;

    /**
     * @param        $user
     * @param bool   $forForm
     * @return array
     */
    public function denormalize($user, bool $forForm = true): array;

    /**
     * @param               $user
     * @param \ArrayObject  $output
     * @return void
     */
    public function viewSections($user, \ArrayObject $output): void;

    /**
     * @return Collection
     */
    public function getFieldSearch(): Collection;

    /**
     * @param SectionForm $section
     * @param string|null $resolution
     * @return void
     */
    public function loadFieldSearch(SectionForm $section, ?string $resolution = null): void;

    /**
     * @param \ArrayObject $rules
     * @return void
     */
    public function loadFieldSearchRules(\ArrayObject $rules): void;

    /**
     * @param User $user
     * @return array
     */
    public function getStructure(User $user): array;
}
