<?php

namespace MetaFox\Profile\Repositories\Eloquent;

use MetaFox\Platform\Repositories\AbstractRepository;
use MetaFox\Profile\Models\Field;
use MetaFox\Profile\Repositories\ValueRepositoryInterface;
use MetaFox\Profile\Models\Value;
use MetaFox\Profile\Support\CustomField;

/**
 * stub: /packages/repositories/eloquent_repository.stub.
 */

/**
 * class ValueRepository.
 */
class ValueRepository extends AbstractRepository implements ValueRepositoryInterface
{
    public function model()
    {
        return Value::class;
    }

    public function deleteValue(Field $field, array $value): void
    {
        $query = Value::query()->where('field_id', $field->entityId());

        if ($field->edit_type == CustomField::MULTI_CHOICE) {
            $query->delete();

            return;
        }

        $query->whereIn('field_value_text', $value)->delete();
    }
}
