<?php

namespace MetaFox\Profile\Repositories\Eloquent;

use MetaFox\Platform\Contracts\User;
use MetaFox\Platform\Repositories\AbstractRepository;
use MetaFox\Profile\Models\Section;
use MetaFox\Profile\Repositories\SectionRepositoryInterface;

/**
 * Class SectionRepository.
 *
 * @method Section getModel()
 */
class SectionRepository extends AbstractRepository implements SectionRepositoryInterface
{
    public function model()
    {
        return Section::class;
    }

    /**
     * @inheritDoc
     */
    public function getSectionForForm(): array
    {
        $data     = [];
        $sections = $this->getModel()->newQuery()->get();
        foreach ($sections as $section) {
            /* @var Section $section */
            $data[] = [
                'value' => $section->entityId(),
                'label' => $section->label,
            ];
        }

        return $data;
    }

    public function deleteOrMoveToNewSection(User $user, array $attribute): bool
    {
        $sectionId    = $attribute['section_id'];
        $newSectionId = $attribute['new_section_id'] ?? 0;
        $section      = $this->find($sectionId);

        if ($newSectionId > 0) {
            //move to new section
            $section->fields()->update(['section_id' => $newSectionId]);

            return (bool) $section->delete();
        }

        $section->fields()->delete();

        return (bool) $section->delete();
    }

    public function orderSections(array $orderIds): bool
    {
        $fields = Section::query()
            ->whereIn('id', $orderIds)
            ->get()
            ->keyBy('id');

        if (!$fields->count()) {
            return true;
        }

        $ordering = 1;

        foreach ($orderIds as $orderId) {
            $orderField = $fields->get($orderId);

            if (null === $orderField) {
                continue;
            }

            $orderField->update(['ordering' => $ordering++]);
        }

        return true;
    }

    public function createSection(array $attributes): Section
    {
        $currentOrdering        = $this->getModel()->newQuery()->max('ordering');
        $attributes['ordering'] = ++$currentOrdering;

        $field = $this->getModel()->newModelInstance();
        $field->fill($attributes);
        $field->save();

        return $field;
    }
}
