<?php

namespace MetaFox\Profile\Repositories\Eloquent;

use MetaFox\Platform\Repositories\AbstractRepository;
use MetaFox\Profile\Models\Field;
use MetaFox\Profile\Models\Value;
use MetaFox\Profile\Repositories\OptionRepositoryInterface;
use MetaFox\Profile\Models\Option;
use MetaFox\Profile\Repositories\ValueRepositoryInterface;

/**
 * stub: /packages/repositories/eloquent_repository.stub.
 */

/**
 * class OptionRepository.
 */
class OptionRepository extends AbstractRepository implements OptionRepositoryInterface
{
    public function model()
    {
        return Option::class;
    }

    protected function valueRepository(): ValueRepositoryInterface
    {
        return resolve(ValueRepositoryInterface::class);
    }

    /**
     * @inheritDoc
     */
    public function createOptions(Field $field, array $attributes): void
    {
        foreach ($attributes as $attribute) {
            $this->getModel()->newQuery()->create([
                'label'    => $attribute['label'],
                'field_id' => $field->entityId(),
            ]);
        }
    }

    /**
     * @inheritDoc
     */
    public function updateOptions(Field $field, array $attributes): void
    {
        foreach ($attributes as $attribute) {
            $field->options()
                ->where('id', $attribute['id'])
                ->update(['label' => $attribute['label']]);
        }
    }
    /**
     * @inheritDoc
     */
    public function removeOptions(Field $field, array $attributes): void
    {
        $removeIds     = collect($attributes)->pluck('id')->toArray();
        $field->options()->whereIn('id', $removeIds)->delete();
        $this->valueRepository()->deleteValue($field, $removeIds);
    }
}
