<?php

namespace MetaFox\Profile\Http\Resources\v1\Section\Admin;

/*
 | --------------------------------------------------------------------------
 | DataGrid Configuration
 | --------------------------------------------------------------------------
 | stub: src/Http/Resources/v1/Admin/DataGrid.stub
 */

use MetaFox\Platform\Resource\Actions;
use MetaFox\Platform\Resource\GridConfig as Grid;
use MetaFox\Platform\Resource\ItemActionMenu;

/**
 * Class DataGrid.
 * @codeCoverageIgnore
 * @ignore
 */
class DataGrid extends Grid
{
    protected string $appName      = 'profile';
    protected string $resourceName = 'section';

    protected function initialize(): void
    {
        if ($this->enableOrder()) {
            $this->sortable();
        }

        $this->addColumn('name')
            ->header(__p('profile::phrase.group'))
            ->flex();

        $this->addColumn('label')
            ->header(__p('core::phrase.label'))
            ->flex();

        $this->addColumn('is_active')
            ->header(__p('core::phrase.is_active'))
            ->asYesNoIcon();
        /*
         * Add default actions
         */
        $this->withActions(function (Actions $actions) {
            $actions->addActions(['delete']);
            $actions->add('edit')
                ->asFormDialog(false)
                ->link('links.editItem');

            if ($this->enableOrder()) {
                $actions->add('orderItem')
                    ->asPost()
                    ->apiUrl('admincp/profile/section/order');
            }
        });

        /*
         * with item action menus
         */
        $this->withItemMenu(function (ItemActionMenu $menu) {
            $menu->withEdit();
            $menu->withDeleteForm();
        });
    }

    protected function enableOrder(): bool
    {
        return true;
    }
}
