<?php

namespace MetaFox\Profile\Http\Resources\v1\Field\Admin;

use Illuminate\Support\Arr;
use MetaFox\Core\Support\Facades\Language;
use MetaFox\Form\AbstractField;
use MetaFox\Profile\Models\Field as Model;

/**
 * --------------------------------------------------------------------------
 * Form Configuration
 * --------------------------------------------------------------------------
 * stub: /packages/resources/edit_form.stub.
 */

/**
 * Class EditFieldForm.
 * @property ?Model $resource
 * @ignore
 * @codeCoverageIgnore
 */
class EditFieldForm extends CreateFieldForm
{
    protected function prepare(): void
    {
        $roles = $this->resource->roles;

        $values = [
            'type_id'         => $this->resource->type_id,
            'is_active'       => $this->resource->is_active,
            'field_name'      => $this->resource->field_name,
            'section_id'      => $this->resource->section_id,
            'var_type'        => $this->resource->var_type,
            'view_type'       => $this->resource->view_type,
            'edit_type'       => $this->resource->edit_type,
            'is_register'     => $this->resource->is_register,
            'is_required'     => $this->resource->is_required,
            'is_search'       => $this->resource->is_search,
            'is_feed'         => $this->resource->is_feed,
            'label'           => Language::getPhraseValues(sprintf('profile::phrase.%s_label', $this->resource->field_name)),
            'description'     => Language::getPhraseValues(sprintf('profile::phrase.%s_description', $this->resource->field_name)),
            'has_label'       => $this->resource->has_label,
            'has_description' => $this->resource->has_description,
            'roles'           => $this->canAssignMultipleRoles() ? $roles->pluck('id')->toArray() : $roles->first()?->id,
        ];

        if (count($this->resource->options)) {
            Arr::set($values, 'options', $this->resource->options);
        }

        $this->title(__p('core::phrase.edit'))
            ->action(apiUrl('admin.profile.field.update', [
                'field' => $this->resource?->id,
            ]))
            ->asPut()
            ->setValue($values);
    }

    public function getActiveField(): ?AbstractField
    {
        return null;
    }

    public function getRegisterField(): ?AbstractField
    {
        return null;
    }
}
