<?php

namespace MetaFox\Profile\Http\Resources\v1\Field\Admin;

/*
 | --------------------------------------------------------------------------
 | DataGrid Configuration
 | --------------------------------------------------------------------------
 | stub: src/Http/Resources/v1/Admin/DataGrid.stub
 */

use MetaFox\Platform\Resource\Actions;
use MetaFox\Platform\Resource\GridConfig as Grid;
use MetaFox\Platform\Resource\ItemActionMenu;

/**
 * Class DataGrid.
 * @codeCoverageIgnore
 * @ignore
 */
class DataGrid extends Grid
{
    protected string $appName      = 'profile';
    protected string $resourceName = 'field';

    protected function initialize(): void
    {
        if ($this->enableOrder()) {
            $this->sortable();
        }

        $this->setSearchForm(new SearchFieldForm());

        $this->addColumn('field_name')
            ->header(__p('core::phrase.name'))
            ->flex();

        $this->addColumn('label')
            ->header(__p('core::phrase.label'))
            ->flex();

        $this->addColumn('group')
            ->header(__p('profile::phrase.group'))
            ->flex();

        $this->addColumn('roles')
            ->header(__p('core::phrase.applicable_roles'))
            ->flex();

        $this->addColumn('is_active')
            ->header(__p('core::phrase.is_active'))
            ->width(150)
            ->asToggleActive();

        $this->addColumn('is_register')
            ->header(__p('profile::phrase.is_register'))
            ->width(150)
            ->asToggle('register');
        /*
         * Add default actions
         */
        $this->withActions(function (Actions $actions) {
            $actions->addActions(['destroy', 'toggleActive']);
            $actions->add('edit')
                ->asFormDialog(false)
                ->link('links.editItem');

            if ($this->enableOrder()) {
                $actions->add('orderItem')
                    ->asPost()
                    ->apiUrl('admincp/profile/field/order');
            }

            $actions->add('register')
                ->apiUrl('admincp/profile/field/register/:id');
        });

        /*
         * with item action menus
         */
        $this->withItemMenu(function (ItemActionMenu $menu) {
            $menu->withEdit();
            $menu->withDelete();
        });
    }

    protected function enableOrder(): bool
    {
        return true;
    }
}
