<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

/*
 * stub: /packages/database/migration.stub
 */

/*
 * @ignore
 * @codeCoverageIgnore
 * @link \$PACKAGE_NAMESPACE$\Models
 */
return new class () extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        if (!Schema::hasTable('user_custom_sections')) {
            Schema::create('user_custom_sections', function (Blueprint $table) {
                $table->id();
                $table->string('name');
                $table->unsignedTinyInteger('is_active')->default(0);
                $table->unsignedInteger('ordering')->default(0);
                $table->mediumText('extra')->nullable();
                $table->unique(['name']);
            });
        }

        // to do here
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('user_custom_sections');
    }
};
