<?php

namespace MetaFox\Profile\Contracts;

interface CustomFieldSupportInterface
{
    /**
     * @return array
     */
    public function getEditTypeAllowOptions(): array;

    /**
     * @param string $type
     * @return string
     */
    public function transformVarType(string $type): string;

    /**
     * @param string $type
     * @return string
     */
    public function transformVarTypeForSearch(string $type): string;

    /**
     * @param string   $type
     * @param  ?string $resolution
     * @return string
     */
    public function transformForSearch(string $type, ?string $resolution = null): string;

    /**
     * @param string   $varType
     * @param  ?string $editType
     * @return string
     */
    public function transformYupType(string $varType, ?string $editType = null): string;

    /**
     * @param string $type
     * @param mixed  $value
     * @return mixed
     */
    public function transformValueForForm(string $type, mixed &$value): mixed;

    /**
     * @param string $type
     * @param mixed  $value
     * @param array  $options
     * @return mixed
     */
    public function transformValueForSection(string $type, mixed &$value, array $options): mixed;

    /**
     * @param string $type
     * @return bool
     */
    public function allowHtml(string $type): bool;

    /**
     * @param string $type
     * @return bool
     */
    public function allowLink(string $type): bool;

    /**
     * @return array
     */
    public function getAllowedRoleOptions(): array;

    /**
     * @return array
     */
    public function getAllowedRole(): array;
}
