<?php

use Illuminate\Support\Facades\Route;
use MetaFox\Profile\Models\Field;
use MetaFox\Profile\Models\Section;
use Illuminate\Support\Str;

Route::get('profile/field/edit/{id}', function ($id) {
    return seo_sharing_view(
        'admin',
        'admin.profile.edit_field',
        'user_custom_field',
        $id,
        function ($data, $resource) use ($id) {
            if (!$resource) {
                $resource = Field::query()->find($id);
            }

            $label = $resource->editingLabel;

            if (Str::match('/profile::phrase./', $label)) {
                $label = $resource->field_name;
            }

            $data->addBreadcrumb('Manage Custom Fields', '/profile/field/browse');
            $data->addBreadcrumb($label, null);
        }
    );
});

Route::get('profile/section/edit/{id}', function ($id) {
    return seo_sharing_view(
        'admin',
        'admin.profile.edit_section',
        'user_custom_section',
        $id,
        function ($data, $resource) use ($id) {
            if (!$resource) {
                $resource = Section::query()->find($id);
            }

            $label = $resource->label;

            if (Str::match('/profile::phrase./', $label)) {
                $label = $resource->name;
            }

            $data->addBreadcrumb('Manage Custom Group', '/profile/section/browse');
            $data->addBreadcrumb($label, null);
        }
    );
});
