<?php

namespace MetaFox\Photo\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use MetaFox\Photo\Repositories\Eloquent\CategoryRepository;

class MigrateCategoryRelation implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    public function handle(): void
    {
        resolve(CategoryRepository::class)->migrateCategoryRelationAfterImport('photo_category_relations');
    }
}
