<?php

namespace MetaFox\Notification\Repositories\Eloquent;

use Illuminate\Database\Query\Builder;
use Illuminate\Database\Query\JoinClause;
use MetaFox\Notification\Models\NotificationSetting;
use MetaFox\Notification\Repositories\SettingRepositoryInterface;
use MetaFox\Platform\Contracts\IsNotifiable;
use MetaFox\Platform\Repositories\AbstractRepository;

/**
 * stub: /packages/repositories/eloquent_repository.stub.
 */

/**
 * Class SettingRepository.
 * @method Setting getModel()
 */
class SettingRepository extends AbstractRepository implements SettingRepositoryInterface
{
    public function model()
    {
        return NotificationSetting::class;
    }

    public function getChannelsForNotifiable(IsNotifiable $notifiable): array
    {
        $notifiableChannels = [];
        $query        = NotificationSetting::query()
            ->from('notification_types', 'types')
            ->select([
                'types.type', 'modules.channel',
            ])
            ->join('notification_modules as modules', function (JoinClause $join) {
                $join->on('types.module_id', '=', 'modules.module_id');
            })
            ->leftJoin('notification_module_settings as module_settings', function (JoinClause $join) use ($notifiable) {
                $join->on('module_settings.module_id', '=', 'modules.id');
                $join->where('module_settings.user_id', $notifiable->entityId());
            })
            ->leftJoin('notification_settings', function (JoinClause $join)  use ($notifiable) {
                $join->on('notification_settings.type_id', '=', 'types.id');
                $join->on('notification_settings.channel', '=', 'modules.channel');
                $join->where('notification_settings.user_id', $notifiable->entityId());
            })
            ->where(function ($builder) {
                // either 1 or null is considered as activated
                $builder->where('module_settings.user_value', 1);
                $builder->orWhereNull('module_settings.user_value');
            })
            ->where(function ($builder) {
                // either 1 or null is considered as activated
                $builder->where('notification_settings.user_value', 1);
                $builder->orWhereNull('notification_settings.user_value');
            });

        foreach ($query->cursor() as $item) {
            $notifiableChannels[$item->type][] = $item->channel;
        }

        return $notifiableChannels;
    }
}
