<?php

namespace MetaFox\Notification\Http\Resources\v1\Type\Admin;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use MetaFox\Notification\Models\Type as Model;
use MetaFox\Notification\Models\TypeChannel;

/**
 * Class TypeItem.
 * @property Model $resource
 * @SuppressWarnings(PHPMD.UnusedFormalParameter)
 */
class TypeItem extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param Request $request
     *
     * @return array<string, mixed>
     */
    public function toArray($request)
    {
        $obj = $this->resource;

        $data = [
            'id'          => $obj->id,
            'type'        => $obj->type,
            'module_id'   => $obj->module_id,
            'module_name' => $obj->packageName(),
            'title'       => __p($obj->title),
            'can_edit'    => $obj->can_edit,
            'is_request'  => $obj->is_request,
            'is_active'   => $obj->is_active,
            'is_system'   => $obj->is_system,
            'channels'    => $this->getChannels(),
        ];

        return $data;
    }

    protected function getChannels(): array
    {
        $channels = [];
        foreach ($this->resource->typeChannels as $channel) {
            $channels[$channel->channel] = $this->resource->is_active && $channel->is_active;
        }

        return $channels;
    }
}
