<?php

namespace MetaFox\Notification\Contracts;

use MetaFox\Notification\Models\Type;
use MetaFox\Platform\Contracts\IsNotifiable;

interface ChannelManagerInterface
{
    /**
     * get available channels for notification $type which are currently preferred by $notifiable.
     * @param IsNotifiable $notifiable
     * @param string       $type
     *
     * @return array
     */
    public function getChannelsForNotifiableByType(IsNotifiable $notifiable, string $type): array;

    /**
     * get available channels for all notification types which are currently preferred by $notifiable.
     * @param IsNotifiable $notifiable
     *
     * @return array
     */
    public function getChannelsForNotifiable(IsNotifiable $notifiable): array;

    /**
     * get available channels for all notification types which are currently preferred by site configurations.
     * @return array
     */
    public function getChannelsForAllTypes(): array;

    /**
     * @param IsNotifiable $notifiable
     *
     * @return bool
     */
    public function forgetChannelCacheForNotifiable(IsNotifiable $notifiable): bool;
}
