<?php

namespace MetaFox\Mobile\Http\Resources\v1\Admin;

use Illuminate\Support\Arr;
use MetaFox\Form\Builder;
use MetaFox\Form\AbstractForm;
use MetaFox\Mobile\Http\Requests\v1\SiteSettingForm\Admin\UpdateSiteSetttingRequest;
use MetaFox\Localize\Support\Traits\TranslatableSettingFieldTrait;
use MetaFox\Platform\Facades\Settings;

/**
 * | --------------------------------------------------------------------------
 * | Form Configuration
 * | --------------------------------------------------------------------------
 * | stub: src/Http/Resources/v1/Admin/SiteSettingForm.stub.
 */

/**
 * Class SiteSettingForm.
 * @codeCoverageIgnore
 * @ignore
 */
class SiteSettingForm extends AbstractForm
{
    protected function prepare(): void
    {
        $module = 'mobile';
        $vars   = [
            'mobile.admob_banner_uid.android',
            'mobile.admob_banner_uid.ios',
            'mobile.admob_interstitial_uid.android',
            'mobile.admob_interstitial_uid.ios',
            'mobile.admob_rewarded_uid.android',
            'mobile.admob_rewarded_uid.ios',
            'mobile.google_app_id',
            'mobile.apple_app_id',
        ];

        $value = [];

        foreach ($vars as $var) {
            Arr::set($value, $var, Settings::get($var));
        }

        $this->title(__p('core::phrase.settings'))
            ->action('admincp/setting/' . $module)
            ->asPost()
            ->setValue($value);
    }

    protected function initialize(): void
    {
        $this->addBasic()->addFields(
            // Adroid Settings
            Builder::text('mobile.admob_banner_uid.android')
                ->label(__p('mobile::phrase.admob_banner_uid_android_label'))
                ->description(__p('mobile::phrase.admob_banner_uid_android_desc', [
                    'url' => 'https://admob.google.com',
                ])),
            Builder::text('mobile.admob_interstitial_uid.android')
                ->label(__p('mobile::phrase.admob_interstitial_uid_android_label'))
                ->description(__p('mobile::phrase.admob_uid_android_desc')),
            Builder::text('mobile.admob_rewarded_uid.android')
                ->label(__p('mobile::phrase.admob_rewarded_uid_android_label'))
                ->description(__p('mobile::phrase.admob_uid_android_desc')),

            // iOS Settings
            Builder::text('mobile.admob_banner_uid.ios')
                ->label(__p('mobile::phrase.admob_banner_uid_ios_label'))
                ->description(__p('mobile::phrase.admob_uid_ios_desc')),
            Builder::text('mobile.admob_interstitial_uid.ios')
                ->label(__p('mobile::phrase.admob_interstitial_uid_label'))
                ->description(__p('mobile::phrase.admob_uid_ios_desc')),
            Builder::text('mobile.admob_rewarded_uid.ios')
                ->label(__p('mobile::phrase.admob_rewarded_uid_label'))
                ->description(__p('mobile::phrase.admob_uid_ios_desc')),
            Builder::text('mobile.google_app_id')
                ->label(__p('mobile::phrase.google_app_id_label'))
                ->description(__p('mobile::phrase.google_app_id_desc')),
            Builder::text('mobile.apple_app_id')
                ->label(__p('mobile::phrase.apple_app_id_label'))
                ->description(__p('mobile::phrase.apple_app_id_desc')),
        );

        $this->addDefaultFooter(true);
    }

    /**
     * validated.
     * @param  UpdateSiteSetttingRequest $request
     * @return array<mixed>
     */
    public function validated(UpdateSiteSetttingRequest $request): array
    {
        $data = $request->all();

        return $data;
    }
}
