<?php

namespace MetaFox\Hashtag\Observers;

use Illuminate\Support\Str;
use MetaFox\Hashtag\Models\Tag;

/**
 * Class TagObserver.
 */
class TagObserver
{
    public function creating(Tag $tag): void
    {
        $url = Str::lower(Str::slug($tag->text));

        $tag->tag_url =  !empty($url) ? $url : urlencode($tag->text);
    }
}
