<?php

namespace MetaFox\Friend\Listeners;

use Illuminate\Auth\Access\AuthorizationException;
use MetaFox\Friend\Repositories\FriendRepositoryInterface;
use MetaFox\Friend\Repositories\FriendRequestRepositoryInterface;
use MetaFox\Platform\Facades\Settings;
use MetaFox\User\Exceptions\ProfileNotFoundException;
use Metafox\User\Models\User;
use MetaFox\User\Support\Facades\UserEntity;
use Prettus\Validator\Exceptions\ValidatorException;

/**
 * @ignore
 * @codeCoverageIgnore
 */
class UserRegistrationExtraFieldsCreateListener
{
    public function __construct(protected FriendRequestRepositoryInterface $requestRepository, protected FriendRepositoryInterface $friendRepository)
    {
    }

    /**
     * @throws AuthorizationException
     * @throws ValidatorException
     */
    public function handle($model): void
    {
        if (!$model instanceof User) {
            return;
        }

        if (!$model->isApproved() || !$model->hasVerified()) {
            return;
        }

        $ownerId = Settings::get('user.on_signup_new_friend');

        if (!$ownerId) {
            return;
        }

        try {
            $owner = UserEntity::getById($ownerId)->detail;
        } catch (ProfileNotFoundException $e) {
            return;
        }

        if (!$owner) {
            return;
        }

        if (!$owner?->hasAdminRole() && !$owner?->hasStaffRole()) {
            return;
        }

        if ($this->friendRepository->isFriend($ownerId, $model->entityId())) {
            return;
        }

        $this->requestRepository->sendRequest($owner, $model);
        $this->friendRepository->addFriend($owner, $model, true);
    }
}
