<?php

namespace MetaFox\Friend\Listeners;

use MetaFox\Friend\Support\Facades\Friend as FriendFacades;
use MetaFox\Platform\Contracts\Entity;
use MetaFox\Platform\Support\ContentParser;
use MetaFox\User\Support\Facades\User as UserFacades;

/**
 * Class ParseFeedContentListener.
 * @ignore
 * @codeCoverageIgnore
 */
class ParseFeedContentListener
{
    public const CONTENT_PARSING_REGEX = '/\[user=(\d+)\](.+?)\[\/user\]/u';
    /**
     * @param  Entity $item
     * @param  string $content
     * @param  array  $attributeParser
     * @return void
     */
    public function handle(Entity $item, string &$content, array $attributeParser = []): void
    {
        $userIds = UserFacades::getMentions($content);

        if (!count($userIds)) {
            return;
        }

        $users = FriendFacades::getUsersForMention($userIds);

        /** @var ContentParser $parserContent */
        $parserContent = resolve(ContentParser::class);

        $parserContent->setUserCollection($users);
        $parserContent->setContent($content);
        $parserContent->setPattern(self::CONTENT_PARSING_REGEX);
        $parserContent->attributeParser($attributeParser);

        $content = $parserContent->parse();
    }
}
