<?php

namespace MetaFox\EMoney\Repositories;

use Illuminate\Contracts\Pagination\Paginator;
use MetaFox\Payment\Models\Order;
use MetaFox\Payment\Models\Transaction as PaymentTransaction;
use MetaFox\Platform\Contracts\Entity;
use MetaFox\Platform\Contracts\User;
use Prettus\Repository\Eloquent\BaseRepository;
use MetaFox\EMoney\Models\Transaction;

/**
 * Interface Transaction.
 * @method static Transaction|null createTransaction(Order $order, ?PaymentTransaction $transaction = null)
 * @mixin BaseRepository
 * stub: /packages/repositories/interface.stub
 */
interface TransactionRepositoryInterface
{
    /**
     * @param User   $user
     * @param User   $owner
     * @param Entity $entity
     * @param string $currency
     * @param float  $total
     * @return Transaction
     */
    public function createTrackingTransaction(User $user, User $owner, Entity $entity, string $currency, float $total): Transaction;

    /**
     * @param  User             $user
     * @param  User             $owner
     * @param  Entity           $entity
     * @param  string           $currency
     * @param  float            $total
     * @param  float|null       $commissionPercentage
     * @param  int|null         $holdingDays
     * @return Transaction|null
     */
    public function createTransactionForIntegration(User $user, User $owner, Entity $entity, string $currency, float $total, ?float $commissionPercentage = null, ?int $holdingDays = null): ?Transaction;

    /**
     * @param Order $order
     * @return Transaction|null
     */
    public function createOutgoingTransaction(Order $order): ?Transaction;

    /**
     * @param  PaymentTransaction $transaction
     * @return Transaction|null
     */
    public function createIncomingTransaction(PaymentTransaction $transaction): ?Transaction;

    /**
     * @param  Transaction $transaction
     * @return bool
     */
    public function approveTransaction(Transaction $transaction): bool;

    /**
     * @param  User      $user
     * @param  array     $attributes
     * @return Paginator
     */
    public function viewTransactions(User $user, array $attributes = []): Paginator;

    /**
     * @param array $attributes
     * @return Paginator
     */
    public function viewTransactionsAdminCP(array $attributes): Paginator;
}
