<?php

namespace MetaFox\EMoney\Listeners;

use MetaFox\EMoney\Services\Contracts\ConversionRateServiceInterface;
use MetaFox\EMoney\Support\Support;

class GetExchangeRateListener
{
    public function handle(string $base, string $target = Support::DEFAULT_TARGET_CURRENCY_CONVERSION_RATE): ?float
    {
        if ($target == $base) {
            return 0;
        }

        return resolve(ConversionRateServiceInterface::class)->getExchangeRate($base, $target);
    }
}
