<?php

namespace MetaFox\EMoney\Http\Resources\v1\Admin;

use Illuminate\Support\Arr;
use MetaFox\EMoney\Support\Support;
use MetaFox\Form\Builder;
use MetaFox\Form\AbstractForm;
use MetaFox\Platform\Facades\Settings;
use MetaFox\Yup\Yup;

/**
 | --------------------------------------------------------------------------
 | Form Configuration
 | --------------------------------------------------------------------------
 | stub: src/Http/Resources/v1/Admin/SiteSettingForm.stub
 */

/**
 * Class SiteSettingForm.
 * @codeCoverageIgnore
 * @ignore
 */
class SiteSettingForm extends AbstractForm
{
    protected function prepare(): void
    {
        $module = 'ewallet';

        $vars   = [
            'minimum_withdraw',
            'balance_holding_duration',
            'withdraw_fee'
        ];

        $value = [];

        foreach ($vars as $var) {
            $var = sprintf('%s.%s', $module, $var);
            Arr::set($value, $var, Settings::get($var));
        }

        $this->title(__p('core::phrase.settings'))
            ->action('admincp/setting/' . $module)
            ->asPost()
            ->setValue($value);
    }

    protected function initialize(): void
    {
        $maxWithdrawalValue = str_repeat(9, 12);

        $this->addBasic()
            ->addFields(
                Builder::text('ewallet.withdraw_fee')
                    ->label(__p('ewallet::admin.withdrawal_fee'))
                    ->description(__p('ewallet::admin.withdrawal_fee_desc'))
                    ->required()
                    ->yup(
                        Yup::number()
                            ->required(__p('validation.field_is_a_required_field', [
                                'field' => __p('ewallet::admin.withdrawal_fee'),
                            ]))
                            ->min(0)
                            ->max(100)
                            ->setError('typeError', __p('ewallet::admin.withdrawal_fee_format_is_invalid'))
                    ),
                Builder::text('ewallet.minimum_withdraw')
                    ->label(__p('ewallet::admin.minimum_withdraw_label'))
                    ->description(__p('ewallet::admin.minimum_withdraw_desc'))
                    ->required()
                    ->asNumber()
                    ->startAdornment(Support::DEFAULT_TARGET_CURRENCY_CONVERSION_RATE)
                    ->preventScrolling()
                    ->maxLength(12)
                    ->yup(
                        Yup::number()
                            ->required(__p('validation.field_is_a_required_field', [
                                'field' => __p('ewallet::admin.minimum_withdraw_label'),
                            ]))
                            ->min(0)
                            ->max($maxWithdrawalValue, __p('ewallet::validation.max_withdraw_value', ['number' => number_format($maxWithdrawalValue)]))
                            ->setError('typeError', __p('ewallet::admin.minimum_withdraw_format_is_invalid'))
                    ),
                Builder::text('ewallet.balance_holding_duration')
                    ->label(__p('ewallet::admin.balance_holding_duration_label'))
                    ->description(__p('ewallet::admin.balance_holding_duration_desc'))
                    ->required()
                    ->yup(
                        Yup::number()
                            ->required(__p('validation.field_is_a_required_field', [
                                'field' => __p('ewallet::admin.balance_holding_duration_label'),
                            ]))
                            ->min(0)
                            ->setError('typeError', __p('ewallet::admin.balance_holding_duration_format_is_invalid'))
                    ),
            );

        $this->addDefaultFooter(true);
    }
}
