<?php

namespace MetaFox\EMoney\Facades;

use Illuminate\Support\Facades\Facade;
use MetaFox\EMoney\Contracts\SupportInterface;
use MetaFox\Platform\Contracts\User;

/**
 * @method static float     getMinimumWithdrawalAmount()
 * @method static string    getDefaultCurrency()
 * @method static User|null getNotifiable()
 * @method static array     getRequestStatusOptions()
 * @method static array     getRequestStatuses()
 * @method static array     getTransactionStatusOptions()
 * @method static array     getBaseCurrencyOptions(?string $target = null)
 * @method static string    getAppAlias()
 * @method static bool      isUsingNewAlias()
 * @method static array     getSourceOptions()
 * @method static array     getTypeOptions()
 */
class Emoney extends Facade
{
    protected static function getFacadeAccessor()
    {
        return SupportInterface::class;
    }
}
