<?php

namespace MetaFox\EMoney\Contracts;

use MetaFox\Platform\Contracts\User;

interface SupportInterface
{
    /**
     * @return float
     */
    public function getMinimumWithdrawalAmount(): float;

    /**
     * @return string
     */
    public function getDefaultCurrency(): string;

    /**
     * @return User|null
     */
    public function getNotifiable(): ?User;

    /**
     * @return array
     */
    public function getRequestStatusOptions(): array;

    /**
     * @return array
     */
    public function getRequestStatuses(): array;

    /**
     * @param  string|null $target
     * @return array
     */
    public function getBaseCurrencyOptions(?string $target = null): array;

    /**
     * @return array
     */
    public function getTransactionStatusOptions(): array;

    /**
     * @return bool
     */
    public function isUsingNewAlias(): bool;

    /**
     * @return string
     */
    public function getAppAlias(): string;

    /**
     * @return array
     */
    public function getSourceOptions(): array;

    /**
     * @return array
     */
    public function getTypeOptions(): array;
}
