<?php

namespace MetaFox\Contact\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;
use MetaFox\Contact\Models\Category;
use MetaFox\Contact\Repositories\Eloquent\CategoryRepository;

/**
 * stub: packages/database/seeder-database.stub.
 */

/**
 * Class PackageSeeder.
 *
 * @ignore
 * @codeCoverageIgnore
 */
class PackageSeeder extends Seeder
{
    private CategoryRepository $categoryRepository;

    /**
     * @param CategoryRepository $categoryRepository
     */
    public function __construct(CategoryRepository $categoryRepository)
    {
        $this->categoryRepository = $categoryRepository;
    }

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->categories();
        $this->categoryRelationData();
    }

    private function categories()
    {
        if (Category::query()->exists()) {
            return;
        }

        $categories = [
            [
                'name'     => 'Sales',
                'name_url' => 'sales',
                'ordering' => 0,
            ],
            [
                'name'     => 'Support',
                'name_url' => 'support',
                'ordering' => 1,
            ],
            [
                'name'     => 'Suggestions',
                'name_url' => 'Suggestions',
                'ordering' => 2,
            ],
        ];

        Category::query()->insert($categories);
    }

    protected function categoryRelationData(): void
    {
        if (!Schema::hasTable('contact_category_relations')) {
            return;
        }

        if ($this->categoryRepository->getRelationModel()->newQuery()->exists()) {
            return;
        }

        $this->categoryRepository->createTopLevelCategoryRelation();
        $this->categoryRepository->createCategoryRelation();
    }
}
