<?php

namespace MetaFox\Activity\Listeners;

use MetaFox\Activity\Policies\SharePolicy;
use MetaFox\Platform\Contracts\User;

class CanShareListener
{
    public function handle(string $entityType, User $user, $resource, $newValue = null): bool
    {
        return policy_check(SharePolicy::class, 'share', $entityType, $user, $resource, $newValue);
    }
}
