<?php
/**
 * @author  developer@phpfox.com
 * @license phpfox.com
 */

namespace MetaFox\Activity\Http\Resources\v1\Type\Admin;

use MetaFox\Activity\Contracts\TypeManager;
use MetaFox\App\Repositories\PackageRepositoryInterface;
use MetaFox\Form\AbstractForm;
use MetaFox\Form\Builder;

/**
 * Class BuiltinAdminSearchForm.
 *
 * Generic search form class for admincp.
 * @driverName ignore
 */
class BuiltinAdminSearchForm extends AbstractForm
{
    protected function prepare(): void
    {
        $this->acceptPageParams(['q', 'module_id'])
            ->action('admincp/feed/type');
    }

    protected function initialize(): void
    {
        $this->acceptPageParams(['q', 'module_id']);

        $this->addBasic(['variant' => 'horizontal'])
            ->asHorizontal()
            ->addFields(
                Builder::text('q')
                    ->forAdminSearchForm(),
                Builder::choice('module_id')
                    ->label(__p('app::phrase.app'))
                    ->options($this->getAppOptions())
                    ->forAdminSearchForm(),
                Builder::submit()
                    ->forAdminSearchForm()
            );
    }

    protected function getAppOptions(): array
    {
        $moduleIds = array_column(resolve(TypeManager::class)->getTypes(), 'module_id');

        return array_values(array_filter(resolve(PackageRepositoryInterface::class)->getPackageOptions(), function ($package) use ($moduleIds) {
            return in_array($package['value'], $moduleIds);
        }));
    }
}
