<?php

namespace MetaFox\SEO\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Auth\AuthenticationException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

class SharingController extends Controller
{
    /**
     * @throws AuthenticationException
     */
    public function fallback(Request $request, $url = '/')
    {
        // prevent recursive request.
        $retry   = defined('MFOX_SHARING_RETRY');

        $result = $retry ? null : app('events')
            ->dispatch('parseRoute', [$url], true);

        $resolution = $request->get('resolution', 'web');

        if ($result) {
            // prevent recursive request.
            defined('MFOX_SHARING_RETRY') or define('MFOX_SHARING_RETRY', true);

            $path = sprintf('sharing' . $result['path']);

            $request = Request::create($path, 'GET', []);

            return Route::dispatch($request);
        }

        return seo_sharing_view($resolution, $url);
    }
}
