<?php

namespace MetaFox\RegexRule\Http\Resources\v1\Admin;

use Illuminate\Support\Arr;
use MetaFox\Form\AbstractForm;
use MetaFox\Form\Builder;
use MetaFox\Localize\Support\Traits\TranslatableSettingFieldTrait;
use MetaFox\Platform\Facades\Settings;

/**
 * | --------------------------------------------------------------------------
 * | Form Configuration
 * | --------------------------------------------------------------------------
 * | stub: src/Http/Resources/v1/Admin/SiteSettingForm.stub.
 */

/**
 * Class SiteSettingForm.
 * @codeCoverageIgnore
 * @ignore
 */
class SiteSettingForm extends AbstractForm
{
    use TranslatableSettingFieldTrait;

    private array $varsTranslatable;

    public function __construct()
    {
        parent::__construct();

        $this->varsTranslatable = [
            'regex.user_name_regex_error_message',
            'regex.display_name_regex_error_message',
            'regex.currency_id_regex_error_message',
        ];
    }

    protected function prepare(): void
    {
        $module = 'regex';
        $vars   = [
            'regex.user_name_regex_rule',
            'regex.display_name_regex_rule',
            'regex.currency_id_regex_rule',
        ];

        $value = [];

        foreach ($vars as $var) {
            Arr::set($value, $var, Settings::get($var));
        }

        $this->getTranslatableValue($value);

        $this->title(__p('core::phrase.settings'))
            ->action('admincp/setting/' . $module)
            ->asPost()
            ->setValue($value);
    }

    protected function initialize(): void
    {
        $this->addBasic()
            ->addFields(
                Builder::text('regex.user_name_regex_rule')
                    ->required()
                    ->label(__p('regex::phrase.username_regex_rule_label'))
                    ->description(__p('regex::phrase.username_regex_rule_description')),
                Builder::translatableText('regex.user_name_regex_error_message')
                    ->required()
                    ->description(__p('regex::phrase.user_name_regex_error_message_desc'))
                    ->buildFields(),
                Builder::divider(),
                Builder::text('regex.display_name_regex_rule')
                    ->required()
                    ->label(__p('regex::phrase.display_name_regex_rule_label'))
                    ->description(__p('regex::phrase.display_name_regex_rule_description')),
                Builder::translatableText('regex.display_name_regex_error_message')
                    ->required()
                    ->description(__p('regex::phrase.display_name_regex_error_message_desc'))
                    ->buildFields(),
                Builder::divider(),
                Builder::text('regex.currency_id_regex_rule')
                    ->required()
                    ->label(__p('regex::phrase.currency_id_regex_rule_label'))
                    ->description(__p('regex::phrase.currency_id_regex_rule_description')),
                Builder::translatableText('regex.currency_id_regex_error_message')
                    ->required()
                    ->description(__p('regex::phrase.currency_id_regex_error_message_desc'))
                    ->sx([])
                    ->buildFields(),
            );

        $this->addDefaultFooter(true);
    }
}
