<?php
/**
 * @author  developer@phpfox.com
 * @license phpfox.com
 */

namespace MetaFox\Payment\Http\Resources\v1;

use MetaFox\Payment\Repositories\GatewayRepositoryInterface;

/**
 * | stub: src/Http/Resources/v1/PackageSetting.stub.
 */

/**
 * Class PackageSetting.
 * @ignore
 * @codeCoverageIgnore
 */
class PackageSetting
{
    public function getWebSettings(): array
    {
        return [
            'payment_gateways' => $this->getPaymentGateways(),
        ];
    }

    protected function getPaymentGateways(): array
    {
        $paymentGateways = resolve(GatewayRepositoryInterface::class)
            ->getConfigurationGateways()->toArray();

        return array_map(function ($paymentGateway) {
            return $paymentGateway['service'];
        }, $paymentGateways);
    }
}
