<?php

namespace MetaFox\Mfa\Support\Services;

use MetaFox\Mfa\Jobs\SendSmsVerificationJob;
use MetaFox\Platform\Contracts\User;
use MetaFox\Platform\MetaFoxConstant;

/**
 * Class Sms.
 *
 * @ignore
 * @codeCoverageIgnore
 */
class Sms extends OTPService
{
    public function isConfigurable(User $user): bool
    {
        $phoneNumber = $user->phone_number;

        return preg_match('/' . MetaFoxConstant::PHONE_NUMBER_REGEX . '/', $phoneNumber);
    }

    public function send(User $user, string $code): bool
    {
        SendSmsVerificationJob::dispatch($user, $code);

        return true;
    }

    public function validateField(): array
    {
        return ['phone_number'];
    }
}
