<?php

namespace MetaFox\Mfa\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;
use MetaFox\Mfa\Mails\VerificationMail;
use MetaFox\Platform\Contracts\User;
use MetaFox\Platform\Facades\Settings;

class SendEmailVerificationJob implements ShouldQueue, ShouldBeUnique
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    public function __construct(protected User $user, protected string $code)
    {
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle(): void
    {
        $siteName = Settings::get('core.general.site_name');

        Mail::to($this->user->email)
            ->send(new VerificationMail([
                'subject' => __p('mfa::phrase.verification_code_subject'),
                'html'    => __p(
                    'mfa::phrase.verification_code_content',
                    ['site_name' => $siteName, 'code' => $this->code]
                ),
            ]));
    }
}
