<?php

namespace MetaFox\Mfa\Http\Resources\v1\Admin;

use Illuminate\Support\Arr;
use MetaFox\Form\Builder;
use MetaFox\Form\AbstractForm;
use MetaFox\Platform\Facades\Settings;
use MetaFox\Yup\Yup;

/**
 * | --------------------------------------------------------------------------
 * | Form Configuration
 * | --------------------------------------------------------------------------
 * | stub: src/Http/Resources/v1/Admin/SiteSettingForm.stub.
 */

/**
 * Class SiteSettingForm.
 * @codeCoverageIgnore
 * @ignore
 */
class SiteSettingForm extends AbstractForm
{
    protected function prepare(): void
    {
        $module = 'mfa';
        $vars   = [
            'mfa.confirm_password',
            'mfa.resend_verification_delay_time',
            'mfa.verify_code_timeout',
            'mfa.brute_force_attempts_count',
            'mfa.brute_force_cool_down',
        ];

        $value = [];

        foreach ($vars as $var) {
            Arr::set($value, $var, Settings::get($var));
        }

        $this->title(__p('core::phrase.settings'))
            ->action('admincp/setting/' . $module)
            ->asPost()
            ->setValue($value);
    }

    protected function initialize(): void
    {
        $this->addBasic()
            ->addFields(
                Builder::switch('mfa.confirm_password')
                    ->label(__p('mfa::phrase.confirm_password_label'))
                    ->description(__p('mfa::phrase.confirm_password_desc')),
                Builder::text('mfa.resend_verification_delay_time')
                    ->label(__p('mfa::phrase.resend_verification_delay_time_label'))
                    ->description(__p('mfa::phrase.resend_verification_delay_time_desc'))
                    ->required()
                    ->yup(Yup::number()->required()->int()->min(1)),
                Builder::text('mfa.verify_code_timeout')
                    ->label(__p('mfa::phrase.verify_code_timeout_label'))
                    ->description(__p('mfa::phrase.verify_code_timeout_desc'))
                    ->required()
                    ->yup(Yup::number()->required()->int()->min(1)),
                Builder::text('mfa.brute_force_attempts_count')
                    ->label(__p('mfa::phrase.force_attempts_count_label'))
                    ->description(__p('mfa::phrase.force_attempts_count_desc'))
                    ->required()
                    ->yup(
                        Yup::number()
                            ->required()
                    ),
                Builder::text('mfa.brute_force_cool_down')
                    ->label(__p('mfa::phrase.force_cool_down_label'))
                    ->description(__p('mfa::phrase.force_cool_down_desc', ['name' => __p('mfa::phrase.force_attempts_count_label')]))
                    ->required()
                    ->yup(
                        Yup::number()
                            ->required()
                    ),
            );

        $this->addDefaultFooter(true);
    }
}
