<?php

namespace MetaFox\Localize\Support\Traits;

use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use MetaFox\Core\Support\Facades\Language;
use MetaFox\Platform\Facades\Settings;

trait TranslatableSettingFieldTrait
{
    protected function saveTranslatableValue(array &$data): void
    {
        $updateData = [];

        foreach ($this->varsTranslatable as $var) {
            $key    = Settings::get($var);
            $values = Arr::get($data, $var);

            foreach ($values as $locale => $text) {
                $updateData[] = [$key, $text ?? '', $locale];
            }
        }

        app('events')->dispatch('localize.phrase.mass_update', [$updateData], true);

        foreach ($this->varsTranslatable as $var) {
            Arr::forget($data, $var);
        }
    }

    protected function getTranslatableValue(array &$data): void
    {
        foreach ($this->varsTranslatable as $var) {
            $value = Settings::get($var);

            if (!is_string($value)) {
                continue;
            }

            Arr::set($data, $var, Language::getPhraseValues($value));
        }
    }

    /**
     * validated.
     * @param  Request      $request
     * @return array<mixed>
     */
    public function validated(Request $request): array
    {
        $data = $request->all();

        $this->saveTranslatableValue($data);

        return $data;
    }
}
