<?php

namespace MetaFox\Localize\Support\Traits;

/**
 * @property array<string, string>|array<string> $translatableAttributes
 * @property string|null                         $name
 * @property string|null                         $name_var
 * @property string|null                         $label
 */
trait TranslatableCategory
{
    use HasTranslatableAttributes;

    protected $translatableAttributes = ['name'];

    public function getNameAttribute($value): string
    {
        return is_string($value) ? __p($value) : $value;
    }

    public function getNameVarAttribute(): ?string
    {
        return $this->attributes['name'] ?? null;
    }

    public function getLabelAttribute($value): ?string
    {
        return $value ? __p($value) : $this->name;
    }
}
