<?php

namespace MetaFox\Localize\Support\Browse\Scopes\Phrase;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Query\Builder as QueryBuilder;
use Illuminate\Database\Query\JoinClause;
use MetaFox\Platform\Support\Browse\Scopes\SearchScope;

/**
 * Class TranslatableTextSearchScope.
 */
class TranslatableTextSearchScope extends SearchScope
{
    private string $locale = 'en';

    public function setLocale(string $locale): self
    {
        $this->locale = $locale;

        return $this;
    }

    public function getLocale(): string
    {
        return $this->locale;
    }

    /**
     * @param Builder $builder
     * @param Model   $model
     */
    public function apply(Builder $builder, Model $model)
    {
        $table = $this->getTable();

        $locale = $this->getLocale();

        $search = $this->getSearchText();

        if ($table == null) {
            $table = $model->getTable();
        }

        $builder->leftJoin('phrases as ps', function (JoinClause $leftJoin) use ($locale, $table) {
            $leftJoin->on("$table.name", '=', 'ps.key')->where('ps.locale', $locale);

            return $leftJoin;
        })
        ->where("$table.name", $this->likeOperator(), "%$search%")
        ->whereNot("$table.name", $this->likeOperator(), '%::%.%')
        ->orWhere(fn (Builder $subWhere) => $subWhere->where('ps.text', $this->likeOperator(), "%$search%"));

        parent::apply($builder, $model);
    }

    public function applyQueryBuilder(QueryBuilder $builder): void
    {
        $table  = $this->getTable();
        $locale = $this->getLocale();
        $search = $this->getSearchText();

        $builder->leftJoin('phrases as ps', function (JoinClause $leftJoin) use ($locale, $table) {
            $leftJoin->on("$table.name", '=', 'ps.key')->where('ps.locale', $locale);

            return $leftJoin;
        })
        ->where("$table.name", $this->likeOperator(), "%$search%")
        ->whereNot("$table.name", $this->likeOperator(), '%::%.%')
        ->orWhere(fn (Builder $subWhere) => $subWhere->where('ps.text', $this->likeOperator(), "%$search%"));

        parent::applyQueryBuilder($builder);
    }
}
